<?php

function get_ads($block,$class)
{
  if(is_logged() && config_item("hide_ads_registered") == '1')
    return false;
  $slot = substr($block, -1);
  if(config_item("ads_slot".$slot) == '')
    return false;
  $CI     =& get_instance();  
  return $CI->load->view('_common/ads/'.$block,array("class" => $class),true);

}

function get_social_icon($url,$type,$icon = '',$bg = '')
{
  if($icon == '')
    $icon = $type;  
  if($bg == '')
    $bg = $type;
  
  if($url)
    return '<a  target="_blank"  rel="nofollow" href="'.$url.'" class="btn azm-social azm-size-32  azm-'.$bg.' exclude external"><i class="fa fa-'.$icon.'"></i></a>';
}
function makeClickableLinks($s) {
  return preg_replace('@(https?://([-\w\.]+[-\w])+(:\d+)?(/([\w/_\.#-]*(\?\S+)?[^\.\s])?)?)@', '<a href="$1" class="exclude external" target="_blank">$1</a>', $s);
}

function converTypeToIcon($type)
{
    $icon['warning']  = 'zmdi-alert-triangle';
    $icon['error']    = 'zmdi-alert-polygon';
    $icon['success']  = 'zmdi-check';
    return $icon[$type];
}

function createRecomendation($type,$target,$ok,$error)
{
  if($type == $target)
    return $ok;
  return $error;
}

function avatar($img,$v=1)
{
  if($img == '')
    $img = base_url()."assets/images/default-avatar.gif";
  if(strpos($img, "http") === false)
    return base_url()."avatars/".$img."?v=".$v;
  return $img;
}


function getInput($data)
{
  $CI     =& get_instance();  
  switch ($data['type']) {
    case 'textarea':
      $input = '<textarea class="form-control '.$data['class'].'" rows="5"  '.$data['attr'].' name="'.$data['var'].'" id="'.$data['var'].'">'.$data['value'].'</textarea>';
      break;    
   
    case 'select':      
      $temp = explode("|", $data['options']);
  
      foreach ($temp as $key => $value) 
      { 
        $lables     = explode(":", $value);
        $valuel     = $lables[0];
        if($lables[1] != '')
          $value = $lables[1];
        if($valuel == '')
          $valuel = $value;

         $selected = '';
         if($value == $data['value'])
           $selected = 'selected="selected"';
          if($value != '')
            $options .= "<option  $selected value='".$value."'>".$valuel."</option>";
      }
      
      $input = '<select class="form-control '.$data['class'].'" '.$data['attr'].' name="'.$data['var'].'" id="'.$data['var'].'">'.$options.'</select>';
      break; 

     case 'select-multiple':      
      $temp = explode("|", $data['options']);
  
      foreach ($temp as $key => $value) 
      { 
        $lables     = explode(":", $value);
        $valuel     = $lables[0];
        if($lables[1] != '')
          $value = $lables[1];
        if($valuel == '')
          $valuel = $value;

         $selected = '';
         $temp_values  = explode(",", $data['value']);
         if(in_array($value, $temp_values))
           $selected = 'selected="selected"';
          if($value != '')
            $options .= "<option  $selected value='".$value."'>".$valuel."</option>";
      }
      
      $input = '<select multiple="multiple" class="form-control '.$data['class'].'" '.$data['attr'].' name="'.$data['var'].'[]" id="'.$data['var'].'">'.$options.'</select>';
      break; 

    default:
      $input = '<input class="form-control '.$data['class'].'" type="'.$data['type'].'" '.$data['attr'].' name="'.$data['var'].'" id="'.$data['var'].'" value="'.$data['value'].'">';
      break;
  }
  $html ='<div class="form-group">
          <label for="'.$data['var'].'" class="col-sm-3 control-label">'.$data['label'].'</label>
          <div class="col-sm-9">
            '.$input.'
            <p class="help-block">'.$data['helper'].'</p>
          </div>
        </div>';
        return  $html;
}

function csrf()
{
  $CI       =& get_instance();
  $name     = $CI->security->get_csrf_token_name();
  $value    = $CI->security->get_csrf_hash();
  return "<input type='hidden' name='$name' value='$value'>";
}

function isBookmark($site)
{
   $CI       =& get_instance();
   $bookmark = $CI->Admin->getTable("bookmarks",array("idsite" => $site,"iduser" => _user("id")));
   if($bookmark->num_rows() ==1)
    return true;
  return false;

}
?>